'Double Deck Poker Solitaire, 8 x 8 grid
option base 1
dim integer c, h, v, i, pn, update_hsf
dim integer data_num, num_cards, num_dealt, num_selected, initial
dim integer card_dealt(64), pnf(64), pscore, hs(100) 'place number filled (0 or 1)
dim integer dcx, dcy 'dealt card x and y pixel values
dim integer suit_cnt(4), rank_cnt(13), twins_cnt(52)
dim integer pair_cnt, kind3_cnt, kind4_cnt, clones_cnt
dim integer low_bound, high_bound, score_type(21)
dim string rank$, suit$, card_array$(104), pa$(64) 'position array
dim string card_file$, hsc$(100), card_size$, high$

'play flac "Juice Newton - Queen of Hearts.flac"
open "DD High Scores.dat" for input as #1
for i = 1 to 100
  line input #1, hsc$(i) 'line input does not use integers, it only uses strings
next i
close #1
for i = 1 to 100
  hs(i) = val(hsc$(i))
next i
initial = 0
num_cards = 0
for i = 1 to 104
  card_array$(i) = ""
next i

again:
num_dealt = 0
num_selected = 0
pscore = 0
dcx = 820
dcy = 68
card_file$ = ""
update_hsf = 0
for i = 1 to 64
  card_dealt(i) = 0
  pnf(i) = 0
  pa$(i) = ""
next i
for i = 1 to 21
  score_type(i) = 0
next i
initialize_counts()

mode 9, 16
cls
color rgb(Green)
font 2 '12x20 pixels
print @(530, 0) "Double Deck Poker Solitaire";
color rgb(Red)
print @(880, 0) "Score";
color rgb(Orange)
print @(530,  40) "75 Royal Flush";
print @(530,  60) "65 Quadruple Clones";
print @(530,  80) "60 Eight of a Kind";
print @(530, 100) "50 Straight Flush";
print @(530, 120) "35 Seven of a Kind";
print @(530, 140) "32 Double Quad";
print @(530, 160) "30 Triple Clones";
print @(530, 180) "28 Four Pairs";
print @(530, 200) "25 Six of a Kind"; 
print @(530, 220) "24 Full House (5+3)";
print @(530, 240) "20 Straight";
print @(530, 260) "18 Flush";
print @(530, 280) "14 Double Triple";
print @(530, 300) "12 Double Clones";
print @(530, 320) "11 Five of a Kind";
print @(530, 340) "10 Three Pairs";
print @(530, 360) " 7 Four of a Kind"; 
print @(530, 380) " 4 Clones";
print @(530, 400) " 3 Three of a Kind";
print @(530, 420) " 2 Two Pairs"; 
print @(530, 440) " 1 One Pair";

font 1 '8x12 pixels
color rgb(Cyan)
print @(530, 480) "Top Scores  Top Scores  Top Scores  Top Scores  Top Scores";
for i = 1 to 20
  if i < 10 then
    high$ = "#" + str$(i) + "  " + str$(hs(i), 4)
  else
    high$ = "#" + str$(i) + " " + str$(hs(i), 4)
  endif  
  high$ = high$ + "    #" + str$(20 + i) + " " + str$(hs(20 + i), 4)
  high$ = high$ + "    #" + str$(40 + i) + " " + str$(hs(40 + i), 4)
  high$ = high$ + "    #" + str$(60 + i) + " " + str$(hs(60 + i), 4)
  if i = 20 then
    high$ = high$ + "   #" + str$(80 + i) + " " + str$(hs(80 + i), 4)
  else
    high$ = high$ + "    #" + str$(80 + i) + " " + str$(hs(80 + i), 4)
  endif
  color rgb(Cyan)
  print @(530, i * 12 + 480) left$(high$, 4)
  color rgb(Yellow)
  print @(562, i * 12 + 480) mid$(high$, 5, 7)
  color rgb(Cyan)
  print @(618, i * 12 + 480) mid$(high$, 12, 5)
  color rgb(Yellow)
  print @(658, i * 12 + 480) mid$(high$, 17, 7)
  color rgb(Cyan)
  print @(714, i * 12 + 480) mid$(high$, 24, 5)
  color rgb(Yellow)
  print @(754, i * 12 + 480) mid$(high$, 29, 7)
  color rgb(Cyan)
  print @(810, i * 12 + 480) mid$(high$, 36, 5)
  color rgb(Yellow)
  print @(850, i * 12 + 480) mid$(high$, 41, 7)
  color rgb(Cyan)
  print @(906, i * 12 + 480) mid$(high$, 48, 5)
  color rgb(Yellow)
  print @(946, i * 12 + 480) mid$(high$, 53, 7)
next i

font 5 '24x32 pixels
color rgb(Grey)
c = 0
for v = 35 to 707 step 96
  for h = 20 to 475 step 65
    inc c
    if c < 10 then
      print @(h, v) str$(c);  
    else
      print @(h - 14, v) str$(c);
    endif
  next h
next v

for v = 0 to 672 step 96
  for h = 0 to 455 step 65 
    box h, v, 61, 94,, rgb(Green)
  next h
next v

if initial = 0 then
  do
    read data_num, rank$, suit$
    if data_num = 0 then
      inc num_cards
      exit do
    endif
    inc num_cards    
    card_array$(num_cards) = rank$ + suit$ 'deck 1 card
    card_array$(num_cards + 52) = rank$ + suit$ 'deck 2 card
  loop
  initial = 1
endif

deal_card()
calculate_score()
ending()

sub deal_card
  do
    if num_dealt = 64 then exit do
    try_again:
    num_selected = int(rnd * 104 + 1)
    for i = 1 to num_dealt
      if num_selected = card_dealt(i) then goto try_again:
    next i
    inc num_dealt
    card_dealt(num_dealt) = num_selected
    dcx = 820 : dcy = 68
    load_card("L")    
    font 2
    color rgb(Green)
    ask_again:
    print @(820, 258) "      " 'Erase the user's input
    print @(820, 238) "Place number"
    print @(820, 258) "";: input pn
    if pn < 1 or pn > 64 then goto ask_again: 'Only 1 - 64 allowed
    if pnf(pn) = 1 then goto ask_again: 'Position already has a placed card
    dcx = 65 * ((pn - 1) mod 8)
    dcy = 96 * fix((pn - 1) / 8)
    load_card("S")      
    pa$(pn) = card_array$(num_selected) 
    pnf(pn) = 1 'The position has been filled with a card
    print @(820, 258) "      " 'erase the user's input
  loop
end sub

sub load_card(card_size$)
  if card_size$ = "L" then
    card_file$ = "98x150 PNG Cards/" + card_array$(num_selected) + " 98x150.png"
  elseif card_size$ = "S" then
    card_file$ = "61x94 PNG Cards/" + card_array$(num_selected) + " 61x94.png"
  end if
  load png card_file$, dcx, dcy  
end sub

sub initialize_counts
  for i = 1 to 4
    suit_cnt(i) = 0
  next i
  for i = 1 to 13
    rank_cnt(i) = 0
  next i
  for i = 1 to 21
    score_type(i) = 0
  next i
  for i = 1 to 52
    twins_cnt(i) = 0
  next i
  pair_cnt = 0
  kind3_cnt = 0
  kind4_cnt = 0
  clones_cnt = 0
end sub

sub inside_for
  if right$(pa$(i), 1) = "D" then inc suit_cnt(1)
  if right$(pa$(i), 1) = "C" then inc suit_cnt(2)
  if right$(pa$(i), 1) = "S" then inc suit_cnt(3)
  if right$(pa$(i), 1) = "H" then inc suit_cnt(4)
  if left$(pa$(i), 1) = "A" then inc rank_cnt(1)
  if left$(pa$(i), 1) = "2" then inc rank_cnt(2)
  if left$(pa$(i), 1) = "3" then inc rank_cnt(3)
  if left$(pa$(i), 1) = "4" then inc rank_cnt(4)
  if left$(pa$(i), 1) = "5" then inc rank_cnt(5)
  if left$(pa$(i), 1) = "6" then inc rank_cnt(6)
  if left$(pa$(i), 1) = "7" then inc rank_cnt(7)
  if left$(pa$(i), 1) = "8" then inc rank_cnt(8)
  if left$(pa$(i), 1) = "9" then inc rank_cnt(9)
  if left$(pa$(i), 2) = "10" then inc rank_cnt(10)
  if left$(pa$(i), 1) = "J" then inc rank_cnt(11)
  if left$(pa$(i), 1) = "Q" then inc rank_cnt(12)
  if left$(pa$(i), 1) = "K" then inc rank_cnt(13) 
  if pa$(i) = "2D" then inc twins_cnt(1)
  if pa$(i) = "3D" then inc twins_cnt(2)
  if pa$(i) = "4D" then inc twins_cnt(3)
  if pa$(i) = "5D" then inc twins_cnt(4)
  if pa$(i) = "6D" then inc twins_cnt(5)
  if pa$(i) = "7D" then inc twins_cnt(6)
  if pa$(i) = "8D" then inc twins_cnt(7)
  if pa$(i) = "9D" then inc twins_cnt(8)
  if pa$(i) = "10D" then inc twins_cnt(9)
  if pa$(i) = "JD" then inc twins_cnt(10)
  if pa$(i) = "QD" then inc twins_cnt(11)
  if pa$(i) = "KD" then inc twins_cnt(12)
  if pa$(i) = "AD" then inc twins_cnt(13)
  if pa$(i) = "2C" then inc twins_cnt(14)
  if pa$(i) = "3C" then inc twins_cnt(15)
  if pa$(i) = "4C" then inc twins_cnt(16)
  if pa$(i) = "5C" then inc twins_cnt(17)
  if pa$(i) = "6C" then inc twins_cnt(18)
  if pa$(i) = "7C" then inc twins_cnt(19)
  if pa$(i) = "8C" then inc twins_cnt(20)
  if pa$(i) = "9C" then inc twins_cnt(21)
  if pa$(i) = "10C" then inc twins_cnt(22)
  if pa$(i) = "JC" then inc twins_cnt(23)
  if pa$(i) = "QC" then inc twins_cnt(24)
  if pa$(i) = "KC" then inc twins_cnt(25)
  if pa$(i) = "AC" then inc twins_cnt(26)
  if pa$(i) = "2S" then inc twins_cnt(27)
  if pa$(i) = "3S" then inc twins_cnt(28)
  if pa$(i) = "4S" then inc twins_cnt(29)
  if pa$(i) = "5S" then inc twins_cnt(30)
  if pa$(i) = "6S" then inc twins_cnt(31)
  if pa$(i) = "7S" then inc twins_cnt(32)
  if pa$(i) = "8S" then inc twins_cnt(33)
  if pa$(i) = "9S" then inc twins_cnt(34)
  if pa$(i) = "10S" then inc twins_cnt(35)
  if pa$(i) = "JS" then inc twins_cnt(36)
  if pa$(i) = "QS" then inc twins_cnt(37)
  if pa$(i) = "KS" then inc twins_cnt(38)
  if pa$(i) = "AS" then inc twins_cnt(39)
  if pa$(i) = "2H" then inc twins_cnt(40)
  if pa$(i) = "3H" then inc twins_cnt(41)
  if pa$(i) = "4H" then inc twins_cnt(42)
  if pa$(i) = "5H" then inc twins_cnt(43)
  if pa$(i) = "6H" then inc twins_cnt(44)
  if pa$(i) = "7H" then inc twins_cnt(45)
  if pa$(i) = "8H" then inc twins_cnt(46)
  if pa$(i) = "9H" then inc twins_cnt(47)
  if pa$(i) = "10H" then inc twins_cnt(48)
  if pa$(i) = "JH" then inc twins_cnt(49)
  if pa$(i) = "QH" then inc twins_cnt(50)
  if pa$(i) = "KH" then inc twins_cnt(51)
  if pa$(i) = "AH" then inc twins_cnt(52)
end sub

sub calculate_score
  low_bound = 1 : high_bound = 8
  for h = 1 to 8 'the horizontal rows 
    initialize_counts()
    for i = low_bound to high_bound
      inside_for()
    next i 
    calc_part2()
    inc low_bound, 8
    inc high_bound, 8
  next h

  low_bound = 1 : high_bound = 57
  for v = 1 to 8 'the vertical columns
    initialize_counts()
    for i = low_bound to high_bound step 8
      inside_for()
    next i 
    calc_part2()
    inc low_bound
    inc high_bound
  next v
end sub

sub calc_part2
  if suit_cnt(1) = 8 or suit_cnt(2) = 8 or suit_cnt(3) = 8 or suit_cnt(4) = 8 then score_type(11) = 1 'Flush
  if score_type(11) = 1 and rank_cnt(1) = 1 and rank_cnt(13) = 1 and rank_cnt(12) = 1 then
    if rank_cnt(11) = 1 and rank_cnt(10) = 1 and rank_cnt(9) = 1 and rank_cnt(8) = 1 then
      if rank_cnt(7) = 1 then
        score_type(3) = 1 'Royal Flush
      endif
    endif
  endif
  for i = 1 to 6 'Straights ranging from Ace to Eight rank through Six rank to King rank
    if rank_cnt(i) = 1 and rank_cnt(i + 1) = 1 and rank_cnt(i + 2) = 1 and rank_cnt(i + 3) = 1 then
      if rank_cnt(i + 4) = 1 and rank_cnt(i + 5) = 1 and rank_cnt(i + 6) = 1 then
        if rank_cnt(i + 7) = 1 then
          score_type(12) = 1 'Straight 
        endif
      endif
    endif
  next i
  'special case straight from Seven rank to Ace high
  if rank_cnt(7) = 1 and rank_cnt(8) = 1 and rank_cnt(9) = 1 and rank_cnt(10) = 1 then
    if rank_cnt(11) = 1 and rank_cnt(12) = 1 and rank_cnt(13) = 1 and rank_cnt(1) = 1 then
      score_type(12) = 1 'Straight
    endif
  endif
  if score_type(11) = 1 and score_type(12) = 1 then score_type(4) = 1 'Straight Flush
  for i = 1 to 13
    if rank_cnt(i) = 8 then score_type(1) = 1  'Eight of a kind
    if rank_cnt(i) = 7 then score_type(5) = 1  'Seven of a kind
    if rank_cnt(i) = 6 then score_type(7) = 1  'Six of a kind
    if rank_cnt(i) = 5 then score_type(14) = 1 'Five of a kind
    if rank_cnt(i) = 4 then
      score_type(16) = 1 'Four of a kind
      inc kind4_cnt
    endif
    if rank_cnt(i) = 3 then
      score_type(18) = 1 'Three of a kind
      inc kind3_cnt
    endif
    if rank_cnt(i) = 2 then 
      score_type(21) = 1 'One pair
      inc pair_cnt       
    endif
  next i    
  if score_type(14) = 1 and score_type(18) = 1 then score_type(8) = 1 'Full House (5+3)
  if kind4_cnt = 2 then score_type(6) = 1 'Double Quad
  if kind3_cnt = 2 then score_type(13) = 1 'Double Triple
  if pair_cnt = 2 then score_type(19) = 1 'Two pair
  if pair_cnt = 3 then score_type(15) = 1 'Three pair
  if pair_cnt = 4 then score_type(10) = 1 'Four pair
  for i = 1 to 52
    if twins_cnt(i) = 2 then inc clones_cnt    
  next i  
  if clones_cnt = 1 then score_type(20) = 1 'Clones
  if clones_cnt = 2 then score_type(17) = 1 'Double Clones
  if clones_cnt = 3 then score_type(9) = 1  'Triple Clones
  if clones_cnt = 4 then score_type(2) = 1  'Quadruple Clones

  for i = 1 to 1 'dummy loop used so can exit the structure
    if score_type(3) = 1 then 'Royal Flush
      inc pscore, 75
      exit for
    endif
    if score_type(2) = 1 then 'Quadruple Clones
      inc pscore, 65
      exit for
    endif
    if score_type(1) = 1 then 'Eight of a kind
      inc pscore, 60
      exit for
    endif
    if score_type(4) = 1 then 'Straight Flush
      inc pscore, 50
      exit for
    endif
    if score_type(5) = 1 then 'Seven of a kind
      inc pscore, 35
      exit for
    endif
    if score_type(6) = 1 then 'Double Quad
      inc pscore, 32
      exit for
    endif
    if score_type(9) = 1 then 'Triple Clones
      inc pscore, 30
      exit for
    endif
    if score_type(10) = 1 then 'Four Pairs
      inc pscore, 28
      exit for
    endif
    if score_type(7) = 1 then 'Six of a kind
      inc pscore, 25
      exit for
    endif
    if score_type(8) = 1 then 'Full House (5+3)
      inc pscore, 24
      exit for
    endif
    if score_type(12) = 1 then 'Straight
      inc pscore, 20
      exit for
    endif
    if score_type(11) = 1 then 'Flush
      inc pscore, 18
      exit for
    endif
    if score_type(13) = 1 then 'Double Triple
      inc pscore, 14
      exit for
    endif
    if score_type(17) = 1 then 'Double Clones
      inc pscore, 12
      exit for
    endif
    if score_type(14) = 1 then 'Five of a kind
      inc pscore, 11
      exit for
    endif
    if score_type(15) = 1 then 'Three Pairs
      inc pscore, 10
      exit for
    endif
    if score_type(16) = 1 then 'Four of a kind
      inc pscore, 7
      exit for
    endif
    if score_type(20) = 1 then 'Clones
      inc pscore, 4
      exit for
    endif
    if score_type(18) = 1 then 'Three of a kind
      inc pscore, 3
      exit for
    endif
    if score_type(19) = 1 then 'Two Pairs
      inc pscore, 2
      exit for
    endif
    if score_type(21) = 1 then 'One Pair
      inc pscore
      exit for
    endif
  next i
end sub

sub ending
  font 2
  color rgb(Yellow)
  print @(952, 0) pscore;  
  for h = 1 to 100
    if pscore > hs(h) then
      for i = 100 to (h + 1) step -1
        hs(i) = hs(i - 1)
      next i
      hs(h) = pscore
      update_hsf = 1
      exit for
    endif
  next h

  if update_hsf = 1 then
    open "DD High Scores.dat" for output as #1
    for i = 1 to 100
      print #1, hs(i)
    next i
    close #1
  end if
  print @(820, 238) "              ";
  print @(820, 238) "Play Again";
  print @(820, 258) "";: input a$
  if left$(lcase$(a$), 1) = "y" then
    goto again:
  else
    end
  endif  
end sub

data  1, "2", "D"
data  2, "3", "D"
data  3, "4", "D"
data  4, "5", "D"
data  5, "6", "D"
data  6, "7", "D"
data  7, "8", "D"
data  8, "9", "D"
data  9, "10", "D"
data 10, "J", "D"
data 11, "Q", "D"
data 12, "K", "D"
data 13, "A", "D" 
data 14, "2", "C"
data 15, "3", "C"
data 16, "4", "C"
data 17, "5", "C"
data 18, "6", "C"
data 19, "7", "C"
data 20, "8", "C"
data 21, "9", "C"
data 22, "10", "C"
data 23, "J", "C"
data 24, "Q", "C"
data 25, "K", "C"
data 26, "A", "C"
data 27, "2", "S"
data 28, "3", "S"
data 29, "4", "S"
data 30, "5", "S"
data 31, "6", "S"
data 32, "7", "S"
data 33, "8", "S"
data 34, "9", "S"
data 35, "10", "S"
data 36, "J", "S"
data 37, "Q", "S"
data 38, "K", "S"
data 39, "A", "S"
data 40, "2", "H"
data 41, "3", "H"
data 42, "4", "H"
data 43, "5", "H"
data 44, "6", "H"
data 45, "7", "H"
data 46, "8", "H"
data 47, "9", "H"
data 48, "10", "H"
data 49, "J", "H"
data 50, "Q", "H"
data 51, "K", "H"
data 52, "A", "H"
data   0, "0", "0"

